/*
 * Decompiled with CFR 0.152.
 */
package club.sk1er.mods.scrollabletooltips.mixinextras.injector.wrapmethod;

import club.sk1er.mods.scrollabletooltips.mixinextras.injector.wrapmethod.WrapMethod;
import club.sk1er.mods.scrollabletooltips.mixinextras.injector.wrapmethod.WrapMethodApplicatorExtension;
import club.sk1er.mods.scrollabletooltips.mixinextras.injector.wrapoperation.Operation;
import club.sk1er.mods.scrollabletooltips.mixinextras.service.MixinExtrasService;
import club.sk1er.mods.scrollabletooltips.mixinextras.sugar.impl.ShareInfo;
import club.sk1er.mods.scrollabletooltips.mixinextras.utils.CompatibilityHelper;
import java.util.ArrayList;
import java.util.List;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AnnotationNode;
import org.spongepowered.asm.mixin.injection.code.Injector;
import org.spongepowered.asm.mixin.injection.struct.InjectionInfo;
import org.spongepowered.asm.mixin.injection.struct.InjectionNodes;
import org.spongepowered.asm.mixin.injection.struct.Target;
import org.spongepowered.asm.util.Annotations;

public class WrapMethodInjector
extends Injector {
    private final Type operationType;
    private final List<ShareInfo> shares;

    public WrapMethodInjector(InjectionInfo info) {
        super(info, "@WrapMethod");
        this.operationType = MixinExtrasService.getInstance().changePackage(Operation.class, Type.getType((String)CompatibilityHelper.getAnnotation((InjectionInfo)this.info).desc), WrapMethod.class);
        this.shares = new ArrayList<ShareInfo>();
    }

    protected void inject(Target target, InjectionNodes.InjectionNode node2) {
        this.checkTargetModifiers(target, true);
        this.checkSignature(target);
        this.info.addCallbackInvocation(this.methodNode);
        WrapMethodApplicatorExtension.offerWrapper(target, this.methodNode, this.operationType, this.shares);
    }

    private void checkSignature(Target target) {
        int argIndex;
        Injector.InjectorData handler = new Injector.InjectorData(target, "method wrapper");
        String description = String.format("%s %s %s from %s", new Object[]{this.annotationType, handler, this, CompatibilityHelper.getMixin(this.info)});
        if (target.method.name.endsWith("init>")) {
            throw CompatibilityHelper.makeInvalidInjectionException(this.info, String.format("%s tried to target %s but targeting initializer methods is not supported!", description, target));
        }
        handler.coerceReturnType = this.checkCoerce(-1, target.returnType, description, true);
        for (argIndex = 0; argIndex < target.arguments.length; ++argIndex) {
            Type theirType = target.arguments[argIndex];
            if (argIndex >= this.methodArgs.length) {
                throw CompatibilityHelper.makeInvalidInjectionException(this.info, String.format("%s targeting %s doesn't have enough parameters!", description, target));
            }
            this.checkCoerce(argIndex, theirType, description, true);
        }
        if (argIndex >= this.methodArgs.length || !this.methodArgs[argIndex++].equals((Object)this.operationType)) {
            throw CompatibilityHelper.makeInvalidInjectionException(this.info, String.format("%s targeting %s is missing Operation parameter!", description, target));
        }
        List sugars = (List)Annotations.getValue((AnnotationNode)CompatibilityHelper.getAnnotation(this.info), (String)"sugars");
        if (sugars != null) {
            for (int i2 = 0; i2 < argIndex; ++i2) {
                AnnotationNode sugar = (AnnotationNode)sugars.get(i2);
                if (!MixinExtrasService.getInstance().isClassOwned(Type.getType((String)sugar.desc).getClassName())) continue;
                throw CompatibilityHelper.makeInvalidInjectionException(this.info, String.format("%s targeting %s has sugar on a non-trailing param which is not allowed!", description, target));
            }
        }
        while (argIndex < this.methodArgs.length) {
            ShareInfo share;
            if (sugars == null || (share = ShareInfo.getOrCreate(target, (AnnotationNode)sugars.get(argIndex), this.methodArgs[argIndex], CompatibilityHelper.getMixin(this.info).getMixin(), null)) == null) {
                throw CompatibilityHelper.makeInvalidInjectionException(this.info, String.format("%s targeting %s has an excess parameter at index %s!", description, target, argIndex));
            }
            this.shares.add(share);
            ++argIndex;
        }
    }
}

